IF EXISTS(SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_MEDIAF_CALCULAR_FILIAL]') AND type IN(N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_MEDIAF_CALCULAR_FILIAL];
GO

/*
=======================================================================================
'Job.................: Itec - Medias de venda - Step 5 - Média F - Calcular Media F
'Função..............: 
'Objetivo............: Calcular MediaF de casos acima de 3 meses
'Tabelas.............: EST_PROD_CPL_DEMANDA_PROC | EST_PROD_CPL_DEMANDA_PROC_CPL
'Dt Modificação......: 08/05/2021
'Modificação.........: Tag #A001 - Atualiza os parametros que foram gerados no media f calcular lancamentos, validar filial.
					   Tag #A002 - Atualiza os parametros de grupo de curva
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

'Forcar o recalculo
UPDATE EST_ARV_MD_F_GRP_PARAM 			SET FREAV_MEDIAF_ULT_ATU=NULL
UPDATE EST_ARV_MD_F_GRP_PARAM_CURVA		SET FCURVA_ULT_ATU= NULL
*/ 


GO
CREATE PROCEDURE [dbo].[P_MEDIAF_CALCULAR_FILIAL] 
		@CD_EMP		INT = 1, 
		@CD_FILIAL  INT = 0, 
		@CD_USU		INT = 1, 
		@CONSULTA	INT = 0 
WITH ENCRYPTION AS

SET DEADLOCK_PRIORITY HIGH ;
SET NOCOUNT ON;
SET CONTEXT_INFO 0x66666; --Evita disparar a trigger para est_prod_cpl

Print '/*********************************************/'
Print ' Processando a mediaf da filial ' + convert(varchar,@cd_filial) + ' - Time ' + convert( varchar(10), getdate(),108)
Print '/*********************************************/'

	--Calcular parmetros de datas
	DECLARE @DT_INI DATETIME,
			@DT_FIM DATETIME, 
			@AGORA  DATETIME, 
			@ANO_MES0 INT, 
			@ANO_MES1 INT, 
			@ANO_MES2 INT, 
			@ANO_MES3 INT;
	
	DECLARE @CD_CURVA_PD INT 
	
	SET @CD_CURVA_PD =(SELECT CD_CURVA_PD FROM PRC_EMP WHERE CD_EMP = @CD_EMP);

	SELECT	@DT_FIM = DBO.F_ONTEM(),  --Dia anterior
			@DT_INI = DATEADD(day, -29, @DT_FIM), --1 ms e 1 dia atrs
			@AGORA =   CONVERT(DATETIME, CONVERT(VARCHAR(10),GETDATE(),112)),		
			@ANO_MES0 = CONVERT(CHAR(6), GETDATE(), 112), --esse ms
			@ANO_MES1 = CONVERT(CHAR(6), DATEADD(MONTH,-1,GETDATE()), 112), --ms anterior
			@ANO_MES2 = CONVERT(CHAR(6), DATEADD(MONTH,-2,GETDATE()), 112), --2 meses atrs
			@ANO_MES3 = CONVERT(CHAR(6), DATEADD(MONTH,-3,GETDATE()), 112); --3 meses atrs

/*********************************************************************************************/
	 --SELECT @ANO_MES1 ANO_MES1,@ANO_MES2 ANO_MES2,@ANO_MES3 ANO_MES3, @DT_FIM DT_FIM,@DT_INI DT_INI
	--return
	--tabela temporaria que conter a base do clculo

	CREATE TABLE #RS_PROD ( CD_FILIAL	INT, 
							CD_PROD		INT,
							P1			MONEY,
							P2			MONEY,
							PPV			MONEY,
							QT_IT_ATUAL MONEY,
							QT_IT_MES1  MONEY,
							QT_IT_MES2  MONEY,
							QT_IT_MES3  MONEY,
							QT_IT_ATUAL_GRV MONEY,
							QT_IT_MES1_GRV	MONEY,
							QT_IT_MES2_GRV	MONEY,
							QT_IT_MES3_GRV  MONEY,
							MEDIA3M		MONEY,
							SAZ			INT,
							LIMITP		AS MEDIA3M + (MEDIA3M * (PPV/100.0000)), 
							LIMITV		AS MEDIA3M - (MEDIA3M * (PPV/100.0000)),
							DT_NASC DATETIME,
							CD_ARV_MERC_LINHA INT);
	
	CREATE TABLE #TBL_BASE ( CD_EMP			INT,
								CD_FILIAL	INT,
								CD_PROD		INT,
								ANO_MES		VARCHAR(15),
								QT_IT		Money);
							  
	CREATE TABLE #RS_TMP_ARV ( CD_EMP INT, CD_FILIAL INT, CD_PROD INT, 
									P1_SAZ	MONEY,  
									P2_SAZ	MONEY, 
									P1		MONEY, 
									P2		MONEY,
									PPV		MONEY,
									DT_NASC DATETIME,
									CD_ARV_MERC_LINHA INT);

	PRINT 'Carregou parametos auxiliares ' + convert(varchar,getdate(), 108) 

/***********************************************************************************************************************/
	BEGIN TRY
	   BEGIN TRANSACTION
		INSERT INTO EST_PROD_CPL_MEDIAF(CD_EMP,CD_FILIAL,CD_PROD,CD_SIGLA,QTDE_MEDIAF,QTDE_FINANCIADO,QTDE_FACEAMENTO,
											QTDE_LIMITADOR,VALID_QTDE_FACEAMENTO,QT_VD_ATUAL,QT_VD_MES1,QT_VD_MES2,QT_VD_MES3,
											LIMITP,LIMITV,CD_USU,DT_CAD,DT_ULT_ALT,SAZ,DT_NASC,MEDIAF_TRANSF)
		
		SELECT
			   A.CD_EMP
			 , A.CD_FILIAL
			 , A.CD_PROD
			 , A.CD_SIGLA
			 , MEDIAF QTDE_MEDIAF
			 , 0 QTDE_FINANCIADO
			 , 0 QTDE_FACEAMENTO
			 , 0 QTDE_LIMITADOR
			 , NULL VALID_QTDE_FACEAMENTO
			 , 0 QT_VD_ATUAL
			 , 0 QT_VD_MES1
			 , 0 QT_VD_MES2
			 , 0 QT_VD_MES3
			 , 0 LIMITP
			 , 0 LIMITV
			 , 1 CD_USU
			 , GETDATE() DT_CAD
			 , NULL DT_ULT_ALT
			 , 0 SAZ
			 , NULL DT_NASC
			 , 0 MEDIAF_TRANSF
		FROM
			EST_PROD_CPL A
			LEFT JOIN EST_PROD_CPL_MEDIAF B ON A.CD_EMP = B.CD_EMP
											   AND A.CD_FILIAL = B.CD_FILIAL
											   AND A.CD_PROD = B.CD_PROD
		WHERE  B.CD_EMP IS NULL
			   AND A.CD_EMP = @CD_EMP
			   AND A.CD_FILIAL = @CD_FILIAL;

		--------------------------------------------------------------------------------------------------------------------------
		PRINT 'Carregou produtos na tabela de mediaf ' + convert(varchar,getdate(), 108);
	    --Efetuar os clculos e registrar na tabela temporria

		INSERT INTO #RS_TMP_ARV
		SELECT
			   N.CD_EMP
			 , N.CD_FILIAL
			 , N.CD_PROD
			 , arv.P1_SAZ
			 , arv.P2_SAZ
			 , arv.P1
			 , arv.P2
			 , arv.PPV
			 , N.DT_NASC
			 , arv.CD_ARV_MERC_LINHA
		FROM
			V_EST_PROD_EST_ARV_MERCADOLOGICA ARV
			INNER JOIN EST_PROD_CPL_NASC n ON arv.CD_EMP = n.CD_EMP
											  AND arv.CD_FILIAL = n.CD_FILIAL
											  AND arv.CD_PROD = n.CD_PROD
		WHERE  arv.CD_EMP = 1
			   AND n.MEDIA_F_LIBERADA = 1
			   AND arv.CD_FILIAL = @CD_FILIAL
			   AND (ARV.FREAV_MEDIAF_ULT_ATU IS NULL OR ISNULL(ARV.PROXIMO_RECALC,@AGORA) <= @AGORA) 
			    
		--SELECT * FROM #RS_TMP_ARV WHERE CD_PROD=60719
		--------------------------------------------------------------------------------------------------------------------------
		PRINT 'Carregou parametos arvore mercadologica ' + convert(varchar,getdate(), 108);
		CREATE UNIQUE CLUSTERED INDEX #IX_RS_TMP_ARV ON #RS_TMP_ARV (CD_PROD,CD_FILIAL,CD_EMP);		

		INSERT INTO #TBL_BASE 
		SELECT
			   @CD_EMP AS CD_EMP
			 , I.CD_FILIAL
			 , i.CD_PROD
			 , 'QT_IT_ATUAL' AS ANO_MES
			 , SUM(i.QT_IT - isnull(imp.qt_it,0)) AS QT_IT
		FROM
			V_PDV_VD_IT i
			INNER JOIN #RS_TMP_ARV arv ON i.CD_EMP = arv.CD_EMP
										  AND i.CD_FILIAL = arv.CD_FILIAL
										  AND i.CD_PROD = arv.CD_PROD
			OUTER APPLY (SELECT SUM(IMP.QT_IT) AS QT_IT
						 FROM PDV_VD_DEV_EST_PROD_IMP IMP
						 WHERE IMP.CD_EMP = I.CD_EMP
						 AND IMP.CD_FILIAL = I.CD_FILIAL
						 AND IMP.CD_PROD = I.CD_PROD
						 AND IMP.CD_VD = I.CD_VD) IMP
		WHERE  I.CD_EMP = @CD_EMP
			   AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM  --Vendas dos ultimos trinta dias  
			   AND i.CD_FILIAL = @CD_FILIAL
		GROUP BY
				 I.CD_FILIAL
			   , i.CD_PROD; 
		
		--------------------------------------------------------------------------------------------------------------------------
		PRINT 'Carregou venda ultimos 30 dias ' + convert(varchar,getdate(), 108);

		INSERT INTO #TBL_BASE 
		SELECT
			   @CD_EMP AS CD_EMP
			 , mov.CD_FILIAL
			 , mov.CD_PROD
			 , CASE mov.ANO_MES
				   WHEN @ANO_MES1 THEN 'QT_IT_MES1'
				   WHEN @ANO_MES2 THEN 'QT_IT_MES2'
				   WHEN @ANO_MES3 THEN 'QT_IT_MES3'
			   END
			 , QTDE_TOTAL AS QT_IT
		FROM
			EST_PROD_CPL_ANALISE mov
			INNER JOIN #RS_TMP_ARV arv ON mov.CD_EMP = arv.CD_EMP
										  AND mov.CD_FILIAL = arv.CD_FILIAL
										  AND mov.CD_PROD = arv.CD_PROD
		WHERE  mov.ANO_MES BETWEEN @ANO_MES3 AND @ANO_MES1
			   AND mov.CD_FILIAL = @CD_FILIAL	
			   AND mov.CD_EMP = @CD_EMP;

		--------------------------------------------------------------------------------------------------------------------------
		PRINT 'Carregou venda ultimos 3 meses ' + convert(varchar,getdate(), 108);
		 
		INSERT INTO #RS_PROD (CD_FILIAL, 
									CD_PROD,
									P1,
									P2,
									PPV,
									QT_IT_ATUAL,
									QT_IT_MES1,
									QT_IT_MES2,
									QT_IT_MES3,
									QT_IT_ATUAL_GRV,
									QT_IT_MES1_GRV,
									QT_IT_MES2_GRV,
									QT_IT_MES3_GRV,
									MEDIA3M,
									SAZ,
									DT_NASC,
									CD_ARV_MERC_LINHA)
		
			SELECT
				   MOV.CD_FILIAL
				 , MOV.CD_PROD
				 , arv.P1
				 , arv.P2
				 , arv.PPV
				 , MOV.QT_IT_ATUAL
				 , MOV.QT_IT_MES1
				 , MOV.QT_IT_MES2
				 , MOV.QT_IT_MES3
				 , MOV.QT_IT_ATUAL
				 , MOV.QT_IT_MES1
				 , MOV.QT_IT_MES2
				 , MOV.QT_IT_MES3
				 , (QT_IT_ATUAL * (arv.P1 / 100.0000)) + (((MOV.QT_IT_MES1 + MOV.QT_IT_MES2 + MOV.QT_IT_MES3) / 3.0000) * (arv.P2 / 100.0000)) MEDIA3M
				 , 0
				 , ARV.DT_NASC
				 , arv.CD_ARV_MERC_LINHA
			FROM
				(
					SELECT
						   CD_EMP
						 , CD_FILIAL
						 , CD_PROD
						 , ISNULL([QT_IT_ATUAL], 0) AS QT_IT_ATUAL
						 , ISNULL([QT_IT_MES1], 0) AS QT_IT_MES1
						 , ISNULL([QT_IT_MES2], 0) AS QT_IT_MES2
						 , ISNULL([QT_IT_MES3], 0) AS QT_IT_MES3
					FROM
						#TBL_BASE PIVOT(SUM(QT_IT) FOR ANO_MES IN(
																  [QT_IT_ATUAL]
																, [QT_IT_MES1]
																, [QT_IT_MES2]
																, [QT_IT_MES3])) AS pvt
				) MOV
				INNER JOIN #RS_TMP_ARV arv ON MOV.CD_EMP = arv.CD_EMP
											  AND MOV.CD_FILIAL = arv.CD_FILIAL
											  AND MOV.CD_PROD = arv.CD_PROD;
		--SELECT * FROM #TBL_BASE WHERE CD_PROD = 394								  
		--SELECT * FROM #RS_PROD WHERE CD_PROD = 394
		PRINT 'Carregou tabela base de analise ' + convert(varchar,getdate(), 108); 
		CREATE UNIQUE CLUSTERED INDEX #IX_#RS_PROD ON #RS_PROD (CD_PROD,CD_FILIAL);		
		DROP TABLE #TBL_BASE;

		--------------------------------------------------------------------------------------------------------------------------
		--Testando se algum dos produtos calculados esta no periodo de sazonalidade (alta temporada), pois os parametros 
		--P1 e P2 so diferenciados
		UPDATE 
			#RS_PROD
		SET
			P1=P1_SAZ,
			P2=P2_SAZ,
			SAZ=1,
			MEDIA3M = (p.QT_IT_ATUAL*(arv.P1_SAZ/100.0000)) + (((p.QT_IT_MES1 + p.QT_IT_MES2 + p.QT_IT_MES3)/3.0000) * (arv.P2_SAZ/100.0000))	
		FROM         
			EST_PROD_SAZONALIDADE saz 
			INNER JOIN #RS_TMP_ARV  arv ON 
			saz.CD_EMP  = arv.CD_EMP AND 
			saz.CD_PROD = arv.CD_PROD
			INNER JOIN  #RS_PROD p ON
			p.CD_FILIAL = arv.CD_FILIAL AND
			p.CD_PROD   = arv.CD_PROD
		WHERE     
			saz.CD_EMP = @CD_EMP 
			AND saz.MES_SAZONALIDADE = MONTH(@AGORA); 
	
		--------------------------------------------------------------------------------------------------------------------------
		PRINT 'Atualizou a sazionalidade ' + convert(varchar,getdate(), 108); 
	
		--Analisar valores fora dos limites
		UPDATE #RS_PROD
		SET QT_IT_ATUAL=CASE WHEN QT_IT_ATUAL > LIMITP THEN LIMITP --ANALISE DE PICO
							 WHEN QT_IT_ATUAL < LIMITV THEN LIMITV --ANALISE DE VALES
							 ELSE QT_IT_ATUAL END,
			QT_IT_MES1 =CASE WHEN QT_IT_MES1 > LIMITP THEN LIMITP --ANALISE DE PICO
							 WHEN QT_IT_MES1 < LIMITV THEN LIMITV --ANALISE DE VALES
							 ELSE QT_IT_MES1 END,
			QT_IT_MES2 =CASE WHEN QT_IT_MES2 > LIMITP THEN LIMITP --ANALISE DE PICO
							 WHEN QT_IT_MES2 < LIMITV THEN LIMITV --ANALISE DE VALES
							 ELSE QT_IT_MES2 END,
			QT_IT_MES3 =CASE WHEN QT_IT_MES3 > LIMITP THEN LIMITP --ANALISE DE PICO
							 WHEN QT_IT_MES3 < LIMITV THEN LIMITV --ANALISE DE VALES
							 ELSE QT_IT_MES3 END;

		 --------------------------------------------------------------------------------------------------------------------------
		PRINT 'Atualizou a pico e vale ' + convert(varchar,getdate(), 108); 
							 
		IF @CONSULTA= 0
		begin  
			IF EXISTS(SELECT TOP 1 * FROM #RS_PROD)
			BEGIN		
		 
				--Gerando cabecalho 
				INSERT INTO                          EST_PROD_CPL_DEMANDA_PROC(
					   DT_CAD
					 , DT_CAD_REGISTRO
					 , CD_USU
					 , TP_DEMANDA
					 , DT_PROC
					 , STS_PROC
					 , ORIGEM_DEMANDA)
				SELECT
					   CONVERT(CHAR(10), GETDATE(), 112)
					 , GETDATE()
					 , 1
					 , 0
					 , CONVERT(CHAR(10), GETDATE(), 112)
					 , 0
					 , 0;

				--------------------------------------------------------------------------------------------------------------------------
				PRINT 'Gerou cabecalho demanda proc ' + convert(varchar,getdate(), 108); 
				
				INSERT INTO  EST_PROD_CPL_DEMANDA_PROC_CPL(
					   CD_CTR_DEMANDA_PROC
					 , CD_EMP
					 , CD_FILIAL
					 , CD_PROD
					 , QTDE_DEMANDA
					 , QT_VD_ATUAL
					 , QT_VD_MES1
					 , QT_VD_MES2
					 , QT_VD_MES3
					 , LIMITP
					 , LIMITV
					 , SAZ
					 , DT_NASC
					 , STS_PROD
					 , QTDE_DEMANDA_ANTERIOR
					 , CD_SIGLA
					 , CD_SIGLA_ANTERIOR)
				SELECT
					   SCOPE_IDENTITY()
					 , @CD_EMP AS CD_EMP
					 , R.CD_FILIAL
					 , R.CD_PROD
					 , CASE
						   WHEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4) > 0 THEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4)
						   ELSE 0
					   END AS MEDIAF
					 , CONVERT(MONEY, R.QT_IT_ATUAL_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES1_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES2_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES3_GRV)
					 , R.LIMITP
					 , R.LIMITV
					 , R.SAZ
					 , R.DT_NASC
					 , 0 STS_PROD
					 , ISNULL(EST_PROD_CPL_MEDIAF.QTDE_MEDIAF, 0)
					 , Cv.Curva
					 , ISNULL(EST_PROD_CPL_MEDIAF.CD_SIGLA, 0)
				FROM
					#RS_PROD r
					INNER JOIN EST_PROD_CPL_MEDIAF ON R.CD_FILIAL = EST_PROD_CPL_MEDIAF.CD_FILIAL
													  AND R.CD_PROD = EST_PROD_CPL_MEDIAF.CD_PROD
					CROSS APPLY (SELECT ISNULL((SELECT TOP (1) CD_SIGLA
									FROM
										V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL a
									WHERE  a.CD_EMP = @CD_EMP
											AND a.VLR_PARAMETRO <= CASE
																		WHEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4) > 0 THEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4)
																		ELSE 0
																	END
											AND a.CD_FILIAL = R.CD_FILIAL
																	--Modelo antigo da view
																	--AND a.CD_ARV_MERC_LINHA = R.CD_ARV_MERC_LINHA 
											AND a.CD_PROD = R.CD_PROD
									ORDER BY
												VLR_PARAMETRO DESC
									), @CD_CURVA_PD) Curva
								)Cv
				where 
					EST_PROD_CPL_MEDIAF.CD_EMP=@CD_EMP
					AND  EST_PROD_CPL_MEDIAF.CD_FILIAL = @CD_FILIAL	;

				--------------------------------------------------------------------------------------------------------------------------
				PRINT 'Iseriu mediaF para produtos novos ' + convert(varchar,getdate(), 108); 
				--Registrar data da atualizao na tabela EST_ARV_MD_F_GRP_PARAM, e descartar tabela temporria 
				UPDATE p
				  SET
					  FREAV_MEDIAF_ULT_ATU = @AGORA
				FROM   EST_ARV_MD_F_GRP_PARAM p
					   JOIN EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL r ON p.CD_EMP = r.CD_EMP
																   AND p.CD_GRP_PARAM = r.CD_GRP_PARAM
					   JOIN EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA l ON p.CD_EMP = l.CD_EMP
																		   AND p.CD_GRP_PARAM = l.CD_GRP_PARAM
					   JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA_CURVA_FILIAL c ON p.CD_EMP = c.CD_EMP
																			   AND r.CD_FILIAL = c.CD_FILIAL
																			   AND p.CD_SIGLA = c.CD_SGL_ATU
																			   AND l.CD_ARV_MERC_LINHA = c.CD_ARV_MERC_LINHA
					   JOIN #RS_PROD b ON r.CD_FILIAL = b.CD_FILIAL
										  AND c.CD_PROD = b.CD_PROD
				WHERE
					  c.CD_EMP = @CD_EMP
					  AND  c.CD_FILIAL = @CD_FILIAL	;

				--------------------------------------------------------------------------------------------------------------------------
				UPDATE R
				SET
					  FREAV_MEDIAF_FILIAL_ULT_ATU = @AGORA
				FROM   EST_ARV_MD_F_GRP_PARAM p
					   JOIN EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL r ON p.CD_EMP = r.CD_EMP
																   AND p.CD_GRP_PARAM = r.CD_GRP_PARAM
					   JOIN EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA l ON p.CD_EMP = l.CD_EMP
																		   AND p.CD_GRP_PARAM = l.CD_GRP_PARAM
					   JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA_CURVA_FILIAL c ON p.CD_EMP = c.CD_EMP
																			   AND r.CD_FILIAL = c.CD_FILIAL
																			   AND p.CD_SIGLA = c.CD_SGL_ATU
																			   AND l.CD_ARV_MERC_LINHA = c.CD_ARV_MERC_LINHA
					   JOIN #RS_PROD b ON r.CD_FILIAL = b.CD_FILIAL
										  AND c.CD_PROD = b.CD_PROD
				WHERE
					  c.CD_EMP = @CD_EMP
					  AND  c.CD_FILIAL = @CD_FILIAL	;
				
			

			END		
			
			
			PRINT 'Registrou a data atualizacao na tabela EST_ARV_MD_F_GRP_PARAM ' + convert(varchar,getdate(), 108); 
	 
		--Fim
		end
		--------------------------------------------------------------------------------------------------------------------------
-- Tag #A001 e Tag #A002		
		IF @CONSULTA= 0
		begin

			--Atualiza os parametros que foram gerados no media f calcular lancamentos
			PRINT 'Atualiza os parametros que foram gerados no media f calcular lancamentos' + convert(varchar,getdate(), 108); 
			UPDATE p
				SET
					FREAV_MEDIAF_ULT_ATU = @AGORA
			FROM   EST_ARV_MD_F_GRP_PARAM p
					JOIN EST_PARAM_COMPRAS_GRUPO_TMP_PARAM_ATUALIZADO r ON  p.CD_EMP = r.CD_EMP
																			AND p.CD_GRP_PARAM = r.CD_GRP_PARAM
			WHERE
						r.CD_EMP = @CD_EMP
					AND  r.CD_FILIAL = @CD_FILIAL	;

			UPDATE R
			SET
					FREAV_MEDIAF_FILIAL_ULT_ATU = @AGORA
			FROM   EST_PARAM_COMPRAS_GRUPO_TMP_PARAM_ATUALIZADO p
					JOIN EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL r ON P.CD_EMP = R.CD_EMP
															AND P.CD_GRP_PARAM = R.CD_GRP_PARAM 
															AND R.CD_FILIAL = P.CD_FILIAL
			WHERE
					p.CD_EMP = @CD_EMP
					AND  p.CD_FILIAL = @CD_FILIAL;

			DELETE FROM EST_PARAM_COMPRAS_GRUPO_TMP_PARAM_ATUALIZADO
			WHERE
					CD_EMP = @CD_EMP
					AND  CD_FILIAL = @CD_FILIAL	; 
					
					
			UPDATE P
			   SET P.FRQ_MEDIAF_ULT_ATU  =  @AGORA
			  FROM  
				   EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P  				   
				   JOIN #RS_PROD B ON P.CD_FILIAL = B.CD_FILIAL
								  AND P.CD_PROD   = B.CD_PROD
             WHERE P.CD_EMP    = @CD_EMP
			   AND P.CD_FILIAL = @CD_FILIAL	;									  
 
		end




		IF @CONSULTA= 1
			SELECT 
				ROUND((r.QT_IT_ATUAL*(r.P1/100.0000)) + (((r.QT_IT_MES1+r.QT_IT_MES2+r.QT_IT_MES3)/3.0000)*(r.P2/100.0000)),4) as MEDIAF_TST, * 
				FROM #RS_PROD r ;
	 
		COMMIT;
	END TRY
	BEGIN CATCH
		IF @@NESTLEVEL > 0  
			ROLLBACK TRANSACTION; 

		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;
		RETURN -1;	
END CATCH